# Backgrounds, Feats, & More

## Alignment

A typical creature in the game world has an alignment, which broadly describes its moral and personal attitudes. Alignment is a combination of two factors: one identifies morality (good, evil, or neutral), and the other describes attitudes toward society and order (lawful, chaotic, or neutral). Thus, nine distinct alignments define the possible combinations.

These brief summaries of the nine alignments describe the typical behavior of a creature with that alignment. Individuals might vary significantly from that typical behavior, and few people are perfectly and consistently faithful to the precepts of their alignment.

**Lawful good** (LG) creatures can be counted on to do the right thing as expected by society. Gold dragons, paladins, and most dwarves are lawful good.

**Neutral good** (NG) folk do the best they can to help others according to their needs. Many celestials, some cloud giants, and most gnomes are neutral good.

**Chaotic good** (CG) creatures act as their conscience directs, with little regard for what others expect. Copper dragons, many elves, and unicorns are chaotic good.

**Lawful neutral** (LN) individuals act in accordance with law, tradition, or personal codes. Many monks and some wizards are lawful neutral.

**Neutral** (N) is the alignment of those who prefer to steer clear of moral questions and don't take sides, doing what seems best at the time. Lizardfolk, most druids, and many humans are neutral.

**Chaotic neutral** (CN) creatures follow their whims, holding their personal freedom above all else. Many barbarians and rogues, and some bards, are chaotic neutral.

**Lawful evil** (LE) creatures methodically take what they want, within the limits of a code of tradition, loyalty, or order. Devils, blue dragons, and hobgoblins are lawful evil.

**Neutral evil** (NE) is the alignment of those who do whatever they can get away with, without compassion or qualms. Many drow, some cloud giants, and goblins are neutral evil.

**Chaotic evil** (CE) creatures act with arbitrary violence, spurred by their greed, hatred, or bloodlust. Demons, red dragons, and orcs are chaotic evil.

### Alignment in the Multiverse

For many thinking creatures, alignment is a moral choice. Humans, dwarves, elves, and other humanoid races can choose whether to follow the paths of good or evil, law or chaos. According to myth, the good- aligned gods who created these races gave them free will to choose their moral paths, knowing that good without free will is slavery.

The evil deities who created other races, though, made those races to serve them. Those races have strong inborn tendencies that match the nature of their gods. Most orcs share the violent, savage nature of the orc gods, and are thus inclined toward evil. Even if an orc chooses a good alignment, it struggles against its innate tendencies for its entire life. (Even half-orcs feel the lingering pull of the orc god's influence.)

Alignment is an essential part of the nature of celestials and fiends. A devil does not choose to be lawful evil, and it doesn't tend toward lawful evil, but rather it is lawful evil in its essence. If it somehow ceased to be lawful evil, it would cease to be a devil.

Most creatures that lack the capacity for rational thought do not have alignments-they are **unaligned**. Such a creature is incapable of making a moral or ethical choice and acts according to its bestial nature. Sharks are savage predators, for example, but they are not evil; they have no alignment.

## Backgrounds

Every story has a beginning. Your character's background reveals where you came from, how you became an adventurer, and your place in the world. Your fighter might have been a courageous knight or a grizzled soldier. Your wizard could have been a sage or an artisan. Your rogue might have gotten by as a guild thief or commanded audiences as a jester.

Choosing a background provides you with important story cues about your character's identity. The most important question to ask about your background is *what changed*? Why did you stop doing whatever your background describes and start adventuring? Where did you get the money to purchase your starting gear, or, if you come from a wealthy background, why don't you have *more* money? How did you learn the skills of your class? What sets you apart from ordinary people who share your background?

The sample backgrounds in this chapter provide both concrete benefits (features, proficiencies, and languages) and roleplaying suggestions.

### About Backgrounds

#### Proficiencies

Each background gives a character proficiency in two skills (described in "Using Ability Scores").

In addition, most backgrounds give a character proficiency with one or more tools (detailed in "Equipment").

If a character would gain the same proficiency from two different sources, he or she can choose a different proficiency of the same kind (skill or tool) instead.

#### Languages

Some backgrounds also allow characters to learn additional languages beyond those given by race. See "Languages."

#### Equipment

Each background provides a package of starting equipment. If you use the optional rule to spend coin on gear, you do not receive the starting equipment from your background.

#### Suggested Characteristics

A background contains suggested personal characteristics based on your background. You can pick characteristics, roll dice to determine them randomly, or use the suggestions as inspiration for characteristics of your own creation.

#### Customizing a Background

You might want to tweak some of the features of a background so it better fits your character or the campaign setting. To customize a background, you can replace one feature with any other one, choose any two skills, and choose a total of two tool proficiencies or languages from the sample backgrounds. You can either use the equipment package from your background or spend coin on gear as described in the equipment section. (If you spend coin, you can't also take the equipment package suggested for your class.) Finally, choose two personality traits, one ideal, one bond, and one flaw. If you can't find a feature that matches your desired background, work with your GM to create one.

### Acolyte

You have spent your life in the service of a temple to a specific god or pantheon of gods. You act as an intermediary between the realm of the holy and the mortal world, performing sacred rites and offering sacrifices in order to conduct worshipers into the presence of the divine. You are not necessarily a cleric - performing sacred rites is not the same thing as channeling divine power.

Choose a god, a pantheon of gods, or some other quasi-divine being from among those listed in "Fantasy-Historical Pantheons" or those specified by your GM, and work with your GM to detail the nature of your religious service. Were you a lesser functionary in a temple, raised from childhood to assist the priests in the sacred rites? Or were you a high priest who suddenly experienced a call to serve your god in a different way? Perhaps you were the leader of a small cult outside of any established temple structure, or even an occult group that served a fiendish master that you now deny.

**Skill Proficiencies:** Insight, Religion

**Languages:** Two of your choice

**Equipment:** A holy symbol (a gift to you when you entered the priesthood), a prayer book or prayer wheel, 5 sticks of incense, vestments, a set of common clothes, and a pouch containing 15 gp

#### Feature: Shelter of the Faithful

As an acolyte, you command the respect of those who share your faith, and you can perform the religious ceremonies of your deity. You and your adventuring companions can expect to receive free healing and care at a temple, shrine, or other established presence of your faith, though you must provide any material components needed for spells. Those who share your religion will support you (but only you) at a modest lifestyle.

You might also have ties to a specific temple dedicated to your chosen deity or pantheon, and you have a residence there. This could be the temple where you used to serve, if you remain on good terms with it, or a temple where you have found a new home. While near your temple, you can call upon the priests for assistance, provided the assistance you ask for is not hazardous and you remain in good standing with your temple.

#### Suggested Characteristics

Acolytes are shaped by their experience in temples or other religious communities. Their study of the history and tenets of their faith and their relationships to temples, shrines, or hierarchies affect their mannerisms and ideals. Their flaws might be some hidden hypocrisy or heretical idea, or an ideal or bond taken to an extreme.

**Table- Suggested Acolyte Characteristics**

| d8     | Personality Trait                                                                                                          |
|--------|----------------------------------------------------------------------------------------------------------------------------|
| 1      | I idolize a particular hero of my faith, and constantly refer to that person's deeds and example.                          |
| 2      | I can find common ground between the fiercest enemies, empathizing with them and always working toward peace.              |
| 3      | I see omens in every event and action. The gods try to speak to us, we just need to listen                                 |
| 4      | Nothing can shake my optimistic attitude.                                                                                  |
| 5      | I quote (or misquote) sacred texts and proverbs in almost every situation.                                                 |
| 6      | I am tolerant (or intolerant) of other faiths and respect (or condemn) the worship of other gods.                          |
| 7      | I've enjoyed fine food, drink, and high society among my temple's elite. Rough living grates on me.                        |
| 8      | I've spent so long in the temple that I have little practical experience dealing with people in the outside world.         |
| **d6** | **Ideal**                                                                                                                  |
| 1      | **Tradition**. The ancient traditions of worship and sacrifice must be preserved and upheld. (Lawful)                      |
| 2      | **Charity**. I always try to help those in need, no matter what the personal cost. (Good)                                  |
| 3      | **Change**. We must help bring about the changes the gods are constantly working in the world. (Chaotic)                   |
| 4      | **Power**. I hope to one day rise to the top of my faith's religious hierarchy. (Lawful)                                   |
| 5      | **Faith**. I trust that my deity will guide my actions. I have faith that if I work hard, things will go well. (Lawful)    |
| 6      | **Aspiration**. I seek to prove myself worthy of my god's favor by matching my actions against his or her teachings. (Any) |
| **d6** | **Bond**                                                                                                                   |
| 1      | I would die to recover an ancient relic of my faith that was lost long ago.                                                |
| 2      | I will someday get revenge on the corrupt temple hierarchy who branded me a heretic.                                       |
| 3      | I owe my life to the priest who took me in when my parents died.                                                           |
| 4      | Everything I do is for the common people.                                                                                  |
| 5      | I will do anything to protect the temple where I served.                                                                   |
| 6      | I seek to preserve a sacred text that my enemies consider heretical and seek to destroy.                                   |
| **d6** | **Flaw**                                                                                                                   |
| 1      | I judge others harshly, and myself even more severely.                                                                     |
| 2      | I put too much trust in those who wield power within my temple's hierarchy.                                                |
| 3      | My piety sometimes leads me to blindly trust those that profess faith in my god.                                           |
| 4      | I am inflexible in my thinking.                                                                                            |
| 5      | I am suspicious of strangers and expect the worst of them.                                                                 |
| 6      | Once I pick a goal, I become obsessed with it to the detriment of everything else in my life.                              |
|        |                                                                                                                            |

## Beyond 1st Level

As your character goes on adventures and overcomes challenges, he or she gains experience, represented by experience points. A character who reaches a specified experience point total advances in capability. This advancement is called **gaining a level**.

When your character gains a level, his or her class often grants additional features, as detailed in the class description. Some of these features allow you to increase your ability scores, either increasing two scores by 1 each or increasing one score by 2. You can't increase an ability score above 20. In addition, every character's proficiency bonus increases at certain levels.

Each time you gain a level, you gain 1 additional Hit Die. Roll that Hit Die, add your Constitution modifier to the roll, and add the total to your hit point maximum. Alternatively, you can use the fixed value shown in your class entry, which is the average result of the die roll (rounded up).

When your Constitution modifier increases by 1, your hit point maximum increases by 1 for each level you have attained. For example, if your 7th-­‐‑level fighter has a Constitution score of 17, when he reaches 8th level, he increases his Constitution score from 17 to 18, thus increasing his Constitution modifier from +3 to +4. His hit point maximum then increases by 8.

The Character Advancement table summarizes the XP you need to advance in levels from level 1 through level 20, and the proficiency bonus for a character of that level. Consult the information in your character’s class description to see what other improvements you gain at each level.

**Table- Character Advancement**

| Experience Points Required | Level | Prof. Bonus |
| :------------------------- | ----- | ----------- |
| 0                          | 1     | +2          |
| 300                        | 2     | +2          |
| 900                        | 3     | +2          |
| 2,700                      | 4     | +2          |
| 6,500                      | 5     | +3          |
| 14,000                     | 6     | +3          |
| 23,000                     | 7     | +3          |
| 34,000                     | 8     | +3          |
| 48,000                     | 9     | +4          |
| 64,000                     | 10    | +4          |
| 85,000                     | 11    | +4          |
| 100,000                    | 12    | +4          |
| 120,000                    | 13    | +5          |
| 140,000                    | 14    | +5          |
| 165,000                    | 15    | +5          |
| 195,000                    | 16    | +5          |
| 225,000                    | 17    | +6          |
| 265,000                    | 18    | +6          |
| 305,000                    | 19    | +6          |
| 355,000                    | 20    | +6          |

## Feats

A feat represents a talent or an area of expertise that gives a character special capabilities. It embodies training, experience, and abilities beyond what a class provides.

At certain levels, your class gives you the Ability Score Improvement feature. Using the optional feats rule, you can forgo taking that feature to take a feat of your choice instead. You can take each feat only once, unless the feat's description says otherwise.

You must meet any prerequisite specified in a feat to take that feat. If you ever lose a feat's prerequisite, you can't use that feat until you regain the prerequisite. For example, the Grappler feat requires you to have a Strength of 13 or higher. If your Strength is reduced below 13 somehow-perhaps by a withering curse-you can't benefit from the Grappler feat until your Strength is restored.

### Grappler

*Prerequisite: Strength 13 or higher*

You've developed the skills necessary to hold your own in close-quarters grappling. You gain the following benefits:

- You have advantage on attack rolls against a creature you are grappling.
- You can use your action to try to pin a creature grappled by you. To do so, make another grapple check. If you succeed, you and the creature are both restrained until the grapple ends.

## Inspiration

Inspiration is a rule the game master can use to reward you for playing your character in a way that’s true to his or her personality traits, ideal, bond, and flaw. By using inspiration, you can draw on your personality trait of compassion for the downtrodden to give you an edge in negotiating with the Beggar Prince. Or inspiration can let you call on your bond to the defense of your home village to push past the effect of a spell that has been laid on you.

### Gaining Inspiration

Your GM can choose to give you inspiration for a variety of reasons. Typically, GMs award it when you play out your personality traits, give in to the drawbacks presented by a flaw or bond, and otherwise portray your character in a compelling way. Your GM will tell you how you can earn inspiration in the game.

You either have inspiration or you don’t—you can’t stockpile multiple “inspirations” for later use.

### Using Inspiration

If you have inspiration, you can expend it when you make an attack roll, saving throw, or ability check. Spending your inspiration gives you advantage on that roll.

Additionally, if you have inspiration, you can reward another player for good roleplaying, clever thinking, or simply doing something exciting in the game. When another player character does something that really contributes to the story in a fun and interesting way, you can give up your inspiration to give that character inspiration.

## Languages

Your race indicates the languages your character can speak by default, and your background might give you access to one or more additional languages of your choice. Note these languages on your character sheet.

Choose your languages from the Standard Languages table, or choose one that is common in your campaign. With your GM's permission, you can instead choose a language from the Exotic Languages table or a secret language, such as thieves' cant or the tongue of druids.

Some of these languages are actually families of languages with many dialects. For example, the Primordial language includes the Auran, Aquan, Ignan, and Terran dialects, one for each of the four elemental planes. Creatures that speak different dialects of the same language can communicate with one another.

**Table- Standard Languages**

| Language | Typical Speakers | Script   |
|----------|------------------|----------|
| Common   | Humans           | Common   |
| Dwarvish | Dwarves          | Dwarvish |
| Elvish   | Elves            | Elvish   |
| Giant    | Ogres, giants    | Dwarvish |
| Gnomish  | Gnomes           | Dwarvish |
| Goblin   | Goblinoids       | Dwarvish |
| Halfling | Halflings        | Common   |
| Orc      | Orcs             | Dwarvish |
|          |                  |          |

**Table- Exotic Languages**

| Language    | Typical Speakers    | Script    |
|-------------|---------------------|-----------|
| Abyssal     | Demons              | Infernal  |
| Celestial   | Celestials          | Celestial |
| Draconic    | Dragons, dragonborn | Draconic  |
| Deep Speech | Aboleths, cloakers  | -         |
| Infernal    | Devils              | Infernal  |
| Primordial  | Elementals          | Dwarvish  |
| Sylvan      | Fey creatures       | Elvish    |
| Undercommon | Underworld traders  | Elvish    |
|             |                     |           |

## Inspiration

Inspiration is a rule the game master can use to reward you for playing your character in a way that's true to his or her personality traits, ideal, bond, and flaw. By using inspiration, you can draw on your personality trait of compassion for the downtrodden to give you an edge in negotiating with the Beggar Prince. Or inspiration can let you call on your bond to the defense of your home village to push past the effect of a spell that has been laid on you.

### Gaining Inspiration

Your GM can choose to give you inspiration for a variety of reasons. Typically, GMs award it when you play out your personality traits, give in to the drawbacks presented by a flaw or bond, and otherwise portray your character in a compelling way. Your GM will tell you how you can earn inspiration in the game.

You either have inspiration or you don't - you can't stockpile multiple "inspirations" for later use.

### Using Inspiration

If you have inspiration, you can expend it when you make an attack roll, saving throw, or ability check. Spending your inspiration gives you advantage on that roll.

Additionally, if you have inspiration, you can reward another player for good roleplaying, clever thinking, or simply doing something exciting in the game. When another player character does something that really contributes to the story in a fun and interesting way, you can give up your inspiration to give that character inspiration.

## MULTICLASSING

Multiclassing allows you to gain levels in multiple classes. Doing so lets you mix the abilities of those classes to realize a character concept that might not be reflected in one of the standard class options.

With this rule, you have the option of gaining a level in a new class whenever you advance in level, instead of gaining a level in your current class. Your levels in all your classes are added together to determine your character level. For example, if you have three levels in wizard and two in fighter, you're a 5th-level character.

As you advance in levels, you might primarily remain a member of your original class with just a few levels in another class, or you might change course entirely, never looking back at the class you left behind. You might even start progressing in a third or fourth class. Compared to a single-class character of the same level, you'll sacrifice some focus in exchange for versatility.

### Prerequisites

To qualify for a new class, you must meet the ability score prerequisites for both your current class and your new one, as shown in the Multiclassing Prerequisites table. For example, a barbarian who decides to multiclass into the druid class must have both Strength and Wisdom scores of 13 or higher. Without the full training that a beginning character receives, you must be a quick study in your new class, having a natural aptitude that is reflected by higher- than-average ability scores.

**Table- Multiclassing Prerequisites**

| Class     | Ability Score Min.          |
|-----------|-----------------------------|
| Barbarian | Strength 13                 |
| Bard      | Charisma 13                 |
| Cleric    | Wisdom 13                   |
| Druid     | Wisdom 13                   |
| Fighter   | Strength 13 or Dexterity 13 |
| Monk      | Dexterity 13 and Wisdom 13  |
| Paladin   | Strength 13 and Charisma 13 |
| Ranger    | Dexterity 13 and Wisdom 13  |
| Rogue     | Dexterity 13                |
| Sorcerer  | Charisma 13                 |
| Warlock   | Charisma 13                 |
| Wizard    | Intelligence 13             |
|           |                             |

### Experience Points

The experience point cost to gain a level is always based on your total character level, as shown in the Character Advancement table, not your level in a particular class. So, if you are a cleric 6/fighter 1, you must gain enough XP to reach 8th level before you can take your second level as a fighter or your seventh level as a cleric.

### Hit Points and Hit Dice

You gain the hit points from your new class as described for levels after 1st. You gain the 1st-level hit points for a class only when you are a 1st-level character.

You add together the Hit Dice granted by all your classes to form your pool of Hit Dice. If the Hit Dice are the same die type, you can simply pool them together. For example, both the fighter and the paladin have a d10, so if you are a paladin 5/fighter 5, you have ten d10 Hit Dice. If your classes give you Hit Dice of different types, keep track of them separately. If you are a paladin 5/cleric 5, for example, you have five d10 Hit Dice and five d8 Hit Dice.

### Proficiency Bonus

Your proficiency bonus is always based on your total character level, as shown in the Character Advancement table in chapter 1, not your level in a particular class. For example, if you are a fighter 3/rogue 2, you have the proficiency bonus of a 5th- level character, which is +3.

### Proficiencies

When you gain your first level in a class other than your initial class, you gain only some of new class's starting proficiencies, as shown in the Multiclassing Proficiencies table.

**Table- Multiclassing Proficiencies**

| Class     | Proficiencies Gained                                                                                       |
|-----------|------------------------------------------------------------------------------------------------------------|
| Barbarian | Shields, simple weapons, martial weapons                                                                   |
| Bard      | Light armor, one skill of your choice, one musical instrument of your choice                               |
| Cleric    | Light armor, medium armor, shields                                                                         |
| Druid     | Light armor, medium armor, shields (druids will not wear armor or use shields made of metal)               |
| Fighter   | Light armor, medium armor, shields, simple weapons, martial weapons                                        |
| Monk      | Simple weapons, shortswords                                                                                |
| Paladin   | Light armor, medium armor, shields, simple weapons, martial weapons                                        |
| Ranger    | Light armor, medium armor, shields, simple weapons, martial weapons, one skill from the class's skill list |
| Rogue     | Light armor, one skill from the class's skill list, thieves' tools                                         |
| Sorcerer  | -                                                                                                          |
| Warlock   | Light armor, simple weapons                                                                                |
| Wizard    | -                                                                                                          |
|           |                                                                                                            |

### Class Features

When you gain a new level in a class, you get its features for that level. You don't, however, receive the class's starting equipment, and a few features have additional rules when you're multiclassing: Channel Divinity, Extra Attack, Unarmored Defense, and Spellcasting.

### Channel Divinity

If you already have the Channel Divinity feature and gain a level in a class that also grants the feature, you gain the Channel Divinity effects granted by that class, but getting the feature again doesn't give you an additional use of it. You gain additional uses only when you reach a class level that explicitly grants them to you. For example, if you are a cleric 6/paladin 4, you can use Channel Divinity twice between rests because you are high enough level in the cleric class to have more uses. Whenever you use the feature, you can choose any of the Channel Divinity effects available to you from your two classes.

### Extra Attack

If you gain the Extra Attack class feature from more than one class, the features don't add together. You can't make more than two attacks with this feature unless it says you do (as the fighter's version of Extra Attack does). Similarly, the warlock's eldritch invocation Thirsting Blade doesn't give you additional attacks if you also have Extra Attack.

### Unarmored Defense

If you already have the Unarmored Defense feature, you can't gain it again from another class.

### Spellcasting

Your capacity for spellcasting depends partly on your combined levels in all your spellcasting classes and partly on your individual levels in those classes. Once you have the Spellcasting feature from more than one class, use the rules below. If you multiclass but have the Spellcasting feature from only one class, you follow the rules as described in that class.

***Spells Known and Prepared***. You determine what spells you know and can prepare for each class individually, as if you were a single-classed member of that class. If you are a ranger 4/wizard 3, for example, you know three 1st-level ranger spells based on your levels in the ranger class. As 3rd-level wizard, you know three wizard cantrips, and your spellbook contains ten wizard spells, two of which (the two you gained when you reached 3rd level as a wizard) can be 2nd-level spells. If your Intelligence is 16, you can prepare six wizard spells from your spellbook.

Each spell you know and prepare is associated with one of your classes, and you use the spellcasting ability of that class when you cast the spell. Similarly, a spellcasting focus, such as a holy symbol, can be used only for the spells from the class associated with that focus.

If a cantrip of yours increases in power at higher levels, the increase is based on your character level, not your level in a particular class

***Spell Slots***. You determine your available spell slots by adding together all your levels in the bard, cleric, druid, sorcerer, and wizard classes, and half your levels (rounded down) in the paladin and ranger classes. Use this total to determine your spell slots by consulting the Multiclass Spellcaster table.

If you have more than one spellcasting class, this table might give you spell slots of a level that is higher than the spells you know or can prepare. You can use those slots, but only to cast your lower-level spells. If a lower-level spell that you cast, like *burning hands*, has an enhanced effect when cast using a higher-level slot, you can use the enhanced effect, even though you don't have any spells of that higher level.

For example, if you are the aforementioned ranger 4/wizard 3, you count as a 5th-level character when determining your spell slots: you have four 1st-level slots, three 2nd-level slots, and two 3rd-level slots. However, you don't know any 3rd-level spells, nor do you know any 2nd-level ranger spells. You can use the spell slots of those levels to cast the spells you do know-and potentially enhance their effects.

***Pact Magic***. If you have both the Spellcasting class feature and the Pact Magic class feature from the warlock class, you can use the spell slots you gain from the Pact Magic feature to cast spells you know or have prepared from classes with the Spellcasting class feature, and you can use the spell slots you gain from the Spellcasting class feature to cast warlock spells you know.

**Table- Multiclass Spellcaster: Spell Slots per Spell Level**

| Level | 1st | 2nd | 3rd | 4th | 5th | 6th | 7th | 8th | 9th |
|-------|-----|-----|-----|-----|-----|-----|-----|-----|-----|
| 1st   | 2   | -   | -   | -   | -   | -   | -   | -   | -   |
| 2nd   | 3   | -   | -   | -   | -   | -   | -   | -   | -   |
| 3rd   | 4   | 2   | -   | -   | -   | -   | -   | -   | -   |
| 4th   | 4   | 3   | -   | -   | -   | -   | -   | -   | -   |
| 5th   | 4   | 3   | 2   | -   | -   | -   | -   | -   | -   |
| 6th   | 4   | 3   | 3   | -   | -   | -   | -   | -   | -   |
| 7th   | 4   | 3   | 3   | 1   | -   | -   | -   | -   | -   |
| 8th   | 4   | 3   | 3   | 2   | -   | -   | -   | -   | -   |
| 9th   | 4   | 3   | 3   | 3   | 1   | -   | -   | -   | -   |
| 10th  | 4   | 3   | 3   | 3   | 2   | -   | -   | -   | -   |
| 11th  | 4   | 3   | 3   | 3   | 2   | 1   | -   | -   | -   |
| 12th  | 4   | 3   | 3   | 3   | 2   | 1   | -   | -   | -   |
| 13th  | 4   | 3   | 3   | 3   | 2   | 1   | 1   | -   | -   |
| 14th  | 4   | 3   | 3   | 3   | 2   | 1   | 1   | -   | -   |
| 15th  | 4   | 3   | 3   | 3   | 2   | 1   | 1   | 1   | -   |
| 16th  | 4   | 3   | 3   | 3   | 2   | 1   | 1   | 1   | -   |
| 17th  | 4   | 3   | 3   | 3   | 2   | 1   | 1   | 1   | 1   |
| 18th  | 4   | 3   | 3   | 3   | 3   | 1   | 1   | 1   | 1   |
| 19th  | 4   | 3   | 3   | 3   | 3   | 2   | 1   | 1   | 1   |
| 20th  | 4   | 3   | 3   | 3   | 3   | 2   | 2   | 1   | 1   |
|       |     |     |     |     |     |     |     |     |     |

